document.addEventListener('DOMContentLoaded', (event) => {
    const messageList = document.getElementById('message-list');
    const userInput = document.getElementById('user-input');
    const sendButton = document.getElementById('send-button');

    const replies = {

// البرازيل (pt)
'pt': [
    "Olá! Você quer se tornar um jogador profissional no Free Fire? <br><img class='message-image' src='img/img1.jpg'>",
    "Você consegue chegar ao nível de Grandmaster no Free Fire?",
    "Você sofre perdas quando os oponentes jogam contra o seu time? 🤔",
    "Vou apresentar a você a maneira ideal de se tornar um jogador profissional no Free Fire, como os YouTubers profissionais. Está pronto para aplicar os passos necessários? 🚀",
    "Abra na Google Play Store, procure por (Settings Headshot FF) e faça o download. Não se esqueça de avaliar com cinco estrelas e deixar um comentário como o melhor aplicativo para alcançar o profissionalismo no jogo Free Fire.🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>IR PARA A PLAY STORE</a><br><img class ='message-image' src='img/img2.jpg'>",
],

// المكسيك (es)
'es': [
    "¡Hola! ¿Quieres convertirte en un jugador profesional en Free Fire? <br><img class='message-image' src='img/img1.jpg'>",
    "¿Puedes alcanzar el nivel de Gran Maestro en Free Fire?",
    "¿Sufres pérdidas cuando los rivales juegan contra tu equipo? 🤔",
    "Te presentaré la forma ideal de convertirte en un jugador profesional en el juego Free Fire como los YouTubers profesionales. ¿Estás listo para aplicar los pasos necesarios? 🚀",
    "Abre la Google Play Store, busca (Settings Headshot FF) y descárgalo. No olvides calificarlo con cinco estrellas y dejar un comentario como la mejor aplicación para obtener profesionalismo en el juego Free Fire.🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>IR A LA PLAY STORE</a><br><img class ='message-image' src='img/img2.jpg'>",
],

// فيتنام (vi)
'vi': [
    "Xin chào! Bạn có muốn trở thành một người chơi chuyên nghiệp trong Free Fire không? <br><img class='message-image' src='img/img1.jpg'>",
    "Bạn có thể đạt được cấp độ Grandmaster trong Free Fire không?",
    "Bạn có gặp thất bại khi các đối thủ chơi chống lại đội của bạn không? 🤔",
    "Tôi sẽ giới thiệu cho bạn cách thức lý tưởng để trở thành một người chơi chuyên nghiệp trong trò chơi Free Fire như các YouTuber chuyên nghiệp. Bạn đã sẵn sàng để áp dụng các bước cần thiết chưa? 🚀",
    "Mở Google Play Store, tìm kiếm (Settings Headshot FF) và tải xuống. Đừng quên đánh giá năm sao và để lại bình luận là ứng dụng tốt nhất để đạt được sự chuyên nghiệp trong trò chơi Free Fire.🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>ĐI TỚI PLAY STORE</a><br><img class ='message-image' src='img/img2.jpg'>",
],

// كمبوديا (km)
'km': [
    "សួស្ដី! តើអ្នកចង់ក្លាយជាកីឡាករដែលមានជំនាញក្នុង Free Fire ទេ? <br><img class='message-image' src='img/img1.jpg'>",
    "តើអ្នកអាចឈានដល់កម្រិត Grandmaster នៅក្នុង Free Fire ទេ?",
    "តើអ្នកទទួលការខាតបង់ពេលមានក្រុមប្រកួតប្រជែងលេងប្រឆាំងនឹងក្រុមរបស់អ្នកទេ? 🤔",
    "ខ្ញុំនឹងបង្ហាញអ្នកអំពីវិធីសាស្ត្រដែលល្អបំផុតដើម្បីក្លាយជាកីឡាករដែលមានជំនាញក្នុងហ្គេម Free Fire ដូចជាកីឡាករអាជីពក្នុង YouTube។ តើអ្នកបានត្រៀមខ្លួនដើម្បីអនុវត្តជំហានដែលត្រូវការរួចហើយឬនៅ? 🚀",
    "បើកនៅក្នុង Google Play Store ស្វែងរក (Settings Headshot FF) ហើយទាញយកវា។ កុំភ្លេចវាយតម្លៃវាថាជាពីរ-ប្រាំផ្កាយ និងទុកឱ្យមតិយោបល់ថាវាជាកម្មវិធីល្អបំផុតសម្រាប់ទទួលបានជំនាញក្នុងហ្គេម Free Fire។🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>ចូលទៅ PLAY STORE</a><br><img class ='message-image' src='img/img2.jpg'>",
],

// الهند (hi)
'hi': [
    "नमस्ते! क्या आप Free Fire में एक पेशेवर खिलाड़ी बनना चाहते हैं? <br><img class='message-image' src='img/img1.jpg'>",
    "क्या आप Free Fire में Grandmaster स्तर तक पहुँच सकते हैं?",
    "क्या आप हार का सामना करते हैं जब विपक्षी आपकी टीम के खिलाफ खेलते हैं? 🤔",
    "मैं आपको Free Fire खेल में एक पेशेवर खिलाड़ी बनने का आदर्श तरीका प्रस्तुत करूंगा, जैसे कि पेशेवर YouTubers। क्या आप आवश्यक कदमों को लागू करने के लिए तैयार हैं? 🚀",
    "Google Play Store में खोलें, (Settings Headshot FF) की खोज करें, और डाउनलोड करें। इसे पांच सितारों की रेटिंग देना और एक टिप्पणी छोड़ना न भूलें कि यह Free Fire खेल में पेशेवरता प्राप्त करने के लिए सबसे अच्छा एप्लिकेशन है।🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>PLAY STORE पर जाएं</a><br><img class ='message-image' src='img/img2.jpg'>",
],

// غانا (en)
'en': [
    "Hello! Do you want to become a professional player in Free Fire? <br><img class='message-image' src='img/img1.jpg'>",
    "Can you reach the Grandmaster level in Free Fire?",
    "Do you suffer from loss when the opponents play against your team? 🤔",
    "I will present to you the ideal way to become a professional player in the game Free Fire like professional YouTubers. Are you ready to apply the required steps? 🚀",
    "Open in the Google Play Store, search for (Settings Headshot FF), and download it. Don't forget to rate it five stars and leave a comment as the best application for obtaining professionalism in the game Free Fire.🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>GO PLAY STORE</a><br><img class ='message-image' src='img/img2.jpg'>",
],

// مصر (ar)
'ar': [
    "مرحبًا! هل تريد أن تصبح لاعبًا محترفًا في لعبة فري فاير؟ <br><img class='message-image' src='img/img1.jpg'>",
    "هل يمكنك الوصول إلى مستوى جراند ماستر في لعبة فري فاير؟",
    "هل تعاني من الخسارة عندما يلعب الخصوم ضد فريقك؟ 🤔",
    "سأقدم لك الطريقة المثالية لتصبح لاعبًا محترفًا في لعبة فري فاير مثل اليوتيوبرز المحترفين. هل أنت مستعد لتطبيق الخطوات المطلوبة؟ 🚀",
    "افتح متجر جوجل بلاي، وابحث عن (Settings Headshot FF)، وقم بتنزيله. لا تنس تقييمه بخمس نجوم وترك تعليق كأفضل تطبيق للحصول على الاحترافية في لعبة فري فاير.🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>اذهب إلى متجر بلاي</a><br><img class ='message-image' src='img/img2.jpg'>",
],

// الجزائر (ar)
'ar': [
    "مرحبًا! هل تريد أن تصبح لاعبًا محترفًا في لعبة فري فاير؟ <br><img class='message-image' src='img/img1.jpg'>",
    "هل يمكنك الوصول إلى مستوى جراند ماستر في لعبة فري فاير؟",
    "هل تعاني من الخسارة عندما يلعب الخصوم ضد فريقك؟ 🤔",
    "سأقدم لك الطريقة المثالية لتصبح لاعبًا محترفًا في لعبة فري فاير مثل اليوتيوبرز المحترفين. هل أنت مستعد لتطبيق الخطوات المطلوبة؟ 🚀",
    "افتح متجر جوجل بلاي، وابحث عن (Settings Headshot FF)، وقم بتنزيله. لا تنس تقييمه بخمس نجوم وترك تعليق كأفضل تطبيق للحصول على الاحترافية في لعبة فري فاير.🔥<br><br><a class='message-link' href='https://play.google.com/' target='_blank'>اذهب إلى متجر بلاي</a><br><img class ='message-image' src='img/img2.jpg'>",
],
    // ... (other languages remain unchanged)
    
    
    
    
    };

    let responseIndex = 0;

    function displayMessage(message, messageType) {
        const messageElement = document.createElement('div');
        messageElement.innerHTML = message;
        messageElement.classList.add('message-bubble', messageType);
        messageList.appendChild(messageElement);

        const messages = Array.from(messageList.children);
        messages.sort((a, b) => a.getBoundingClientRect().top - b.getBoundingClientRect().top);
        messageList.innerHTML = '';
        messages.forEach((message) => {
            messageList.appendChild(message);
        });

        messageList.scrollTop = messageList.scrollHeight;
    }

    function sendSequentialReply(language) {
        const replyMessages = replies[language] || replies['en'];
        const replyMessage = replyMessages[responseIndex];

        displayMessage(replyMessage, 'incoming-message');
        responseIndex = (responseIndex + 1) % replyMessages.length;

        const audio = new Audio('img/sound/notification.mp3');
        audio.play();
    }

    setTimeout(async () => {
        try {
            const response = await fetch('https://get.geojs.io/v1/ip/country.json');
            const data = await response.json();
            const country = data.country.toLowerCase();

            const languageMap = {
            
            
// 'pt' corresponds to Brazil
'br': 'pt', 

// 'es' corresponds to Mexico
'mx': 'es', 

// 'vi' corresponds to Vietnam
'vn': 'vi', 

// 'km' corresponds to Cambodia
'kh': 'km', 

// 'hi' corresponds to India
'in': 'hi', 

// 'en' corresponds to Ghana
'gh': 'en', 

// 'ar' corresponds to Egypt
'eg': 'ar', 

// 'ar' corresponds to Algeria
'dz': 'ar', 

// 'es' corresponds to Venezuela
've': 'es', 

// 'en' corresponds to Nigeria
'ng': 'en'


            
         
            
            
                // Add language mappings for other countries as needed
            };

            const userLanguage = languageMap[country] || 'en';

            sendSequentialReply(userLanguage);
        } catch (error) {
            console.error('Error fetching user location:', error);
        }
    }, 1000);

    sendButton.addEventListener('click', async () => {
        const userMessage = userInput.value;

        if (userMessage.trim() !== '') {
            displayMessage(userMessage, 'outgoing-message');
            userInput.value = '';

            try {
                const response = await fetch('https://ipinfo.io/json');
                const data = await response.json();
                const country = data.country.toLowerCase();

                const languageMap = {
                
                
// 'pt' corresponds to Brazil
'br': 'pt', 

// 'es' corresponds to Mexico
'mx': 'es', 

// 'vi' corresponds to Vietnam
'vn': 'vi', 

// 'km' corresponds to Cambodia
'kh': 'km', 

// 'hi' corresponds to India
'in': 'hi', 

// 'en' corresponds to Ghana
'gh': 'en', 

// 'ar' corresponds to Egypt
'eg': 'ar', 

// 'ar' corresponds to Algeria
'dz': 'ar', 

// 'es' corresponds to Venezuela
've': 'es', 

// 'en' corresponds to Nigeria
'ng': 'en'


            
                
                
                
                    // Add language mappings for other countries as needed
                };

                const userLanguage = languageMap[country] || 'en';

                sendSequentialReply(userLanguage);
            } catch (error) {
                console.error('Error fetching user location:', error);
            }
        }
    });
});
