<?php
/**
 * GET /api/videos.php
 * Returns all active videos in random order
 * Requires: X-API-Key header
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';

// Set JSON header
header('Content-Type: application/json');

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendErrorResponse('Method not allowed', 405);
}

// Validate API key
requireAPIKey();

try {
    // Get all videos (randomized)
    $videos = getAllVideos(true);

    // Format videos for response
    $formattedVideos = array_map(function($video) {
        return [
            'id' => $video['video_id'],
            'filename' => $video['original_filename'],
            'aspect_ratio' => $video['aspect_ratio'],
            'url' => $video['url'],
            'file_size' => (string)$video['file_size'],
            'duration' => (int)$video['duration'],
            'upload_date' => $video['upload_date']
        ];
    }, $videos);

    // Send response
    sendJSONResponse([
        'success' => true,
        'count' => count($formattedVideos),
        'videos' => $formattedVideos
    ]);

} catch (Exception $e) {
    error_log("API Error (videos.php): " . $e->getMessage());
    sendErrorResponse('Internal server error', 500);
}
?>
