<?php
// Database Initialization Script
// Run this once to create the SQLite database and tables

$dbPath = __DIR__ . '/videos.db';

try {
    // Create SQLite database connection
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Create videos table
    $createTableSQL = "
    CREATE TABLE IF NOT EXISTS videos (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        video_id VARCHAR(50) UNIQUE NOT NULL,
        filename VARCHAR(255) NOT NULL,
        original_filename VARCHAR(255) NOT NULL,
        aspect_ratio VARCHAR(10) NOT NULL,
        file_size INTEGER NOT NULL,
        duration INTEGER DEFAULT 0,
        url TEXT NOT NULL,
        upload_date DATETIME DEFAULT CURRENT_TIMESTAMP,
        status VARCHAR(20) DEFAULT 'active'
    );
    ";

    $db->exec($createTableSQL);

    // Create indexes
    $db->exec("CREATE INDEX IF NOT EXISTS idx_video_id ON videos(video_id);");
    $db->exec("CREATE INDEX IF NOT EXISTS idx_aspect_ratio ON videos(aspect_ratio);");

    echo "Database initialized successfully!\n";
    echo "Database location: " . $dbPath . "\n";

} catch (PDOException $e) {
    die("Database initialization failed: " . $e->getMessage() . "\n");
}
?>
