<?php
/**
 * Video API Backend - Root Page
 * Redirects to admin panel or shows API documentation
 */

require_once __DIR__ . '/includes/admin_auth.php';

// If admin is logged in, redirect to admin panel
if (isAdminLoggedIn()) {
    header('Location: admin/index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video API Backend</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
        }
        .subtitle {
            color: #666;
            margin-bottom: 30px;
        }
        .section {
            margin-bottom: 30px;
        }
        .section h2 {
            color: #444;
            margin-bottom: 15px;
            font-size: 20px;
        }
        .endpoint {
            background: #f5f5f5;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            border-left: 4px solid #667eea;
        }
        .endpoint-method {
            color: #667eea;
            font-weight: bold;
            margin-right: 10px;
        }
        .endpoint-path {
            font-family: 'Courier New', monospace;
            color: #333;
        }
        .endpoint-desc {
            color: #666;
            font-size: 14px;
            margin-top: 5px;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s;
        }
        .btn:hover {
            background: #5568d3;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .info-box {
            background: #e3f2fd;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #2196F3;
            margin-top: 20px;
        }
        .info-box p {
            color: #1565C0;
            margin: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Video API Backend</h1>
        <p class="subtitle">Private Video Hosting API for Android App</p>

        <div class="section">
            <h2>API Endpoints</h2>

            <div class="endpoint">
                <div>
                    <span class="endpoint-method">GET</span>
                    <span class="endpoint-path">/api/videos.php</span>
                </div>
                <p class="endpoint-desc">Get all videos in random order</p>
            </div>

            <div class="endpoint">
                <div>
                    <span class="endpoint-method">GET</span>
                    <span class="endpoint-path">/api/video.php?id={video_id}</span>
                </div>
                <p class="endpoint-desc">Get single video details</p>
            </div>

            <div class="endpoint">
                <div>
                    <span class="endpoint-method">GET</span>
                    <span class="endpoint-path">/api/stream.php?id={video_id}</span>
                </div>
                <p class="endpoint-desc">Stream video file</p>
            </div>
        </div>

        <div class="section">
            <h2>Authentication</h2>
            <p>All API requests require an API key in the request header:</p>
            <div class="endpoint">
                <span class="endpoint-path">X-API-Key: your_api_key_here</span>
            </div>
        </div>

        <div class="section">
            <a href="admin/login.php" class="btn">Admin Login</a>
        </div>

        <div class="info-box">
            <p><strong>Status:</strong> API is running and ready to accept requests</p>
        </div>
    </div>
</body>
</html>
